{
	"perkAcolyteOfTheFlame":{
		"type":"item",
		"category":"perkAcolyteOfTheFlame",
		"picture":{"file":"acolyteOfTheFlame.atf"},
		"name":{"EN":"acolyte of the flame",
				"FR":"acolyte de la flamme",
				"DE":"kumpel flame"},
		"description":{"EN":"This perk increases your mastery of the fire magic.",
					   "FR":"Ce talent augmente votre maîtrise de la magie du feu.",
					   "DE":"Diese Vergünstigung erhöht die Beherrschung der Feuermagie."},
		"bonus":{"pyrotechnicMagic":{"intelligence":0.5},
				 "conjuration":{"willpower":0.5}},
		"resistance":{"fire":-0.1},
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":25, "levelMin":30}
	},
	"perkAnimalFriend":{
		"type":"item",
		"category":"perkAnimalFriend",
		"picture":{"file":"animalFriend.atf"},
		"name":{"EN":"animal friend",
				"FR":"ami des animaux",
				"DE":"tierfreund"},
		"description":{"EN":"This perk increases your pet-related skills.",
					   "FR":"Ce talent augmente vos compétences affiliés aux animaux.",
					   "DE":"Diese Vergünstigung erhöht Ihre haustierbezogenen Fähigkeiten."},
		"bonus":{"zoology":{"charisma":0.5},
				 "breeding":{"charisma":0.5},
				 "training":{"charisma":0.5},
				 "sheepShearing":{"charisma":0.1}},
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":9,
				"races":{"felineM":{"cost":0.5, "levelMin":0.5},
						 "felineF":{"cost":0.5, "levelMin":0.5}}
			   }
	},
	"perkArmyOfTheDead":{
		"type":"item",
		"category":"perkArmyOfTheDead",
		"picture":{"file":"armyOfTheDead.atf"},
		"name":{"EN":"army of the dead",
				"FR":"armée des morts",
				"DE":"armee der toten"},
		"description":{"EN":"This perk allows you to invoke skeletons.",
					   "FR":"Ce talent vous permet d'invoquer des squelettes.",
					   "DE":"Diese Vergünstigung erlaubt Ihnen, skelette aufzurufen."},
		"use":{
			"cooldown":{"id":"armyOfTheDead",
						"time":30,
						"off":{"EN":{"D":["I can't use this perk for now."]},
							   "FR":{"D":["Je ne peux pas encore réutiliser ce talent."]},
							   "DE":{"D":["Ich kann diese Vergünstigung jetzt nicht benutzen."]}}},
			"costPrimaryCharacteristic":{"mana":20},
			"create":[{"id":"skeleton", "power":{"necromanticMagic":0.2}}],
			"xpSecondaryCharacteristic":{"willpower":20},
			"xpSkill":{"necromanticMagic":20},
			"effect":"poisonGasEffect",
			"tooMany":{"EN":"No way! There's too many summonings.",
					   "FR":"Impossible ! Il y a déjà trop d'invocations.",
					   "DE":"Auf keinen Fall! Es gibt zu viele Beschwörungen."}
		},
		"secret":true,
		"indestructible":true,
		"perk":{"cost":100, "levelMin":100,
				"races":{"darkElfM":{"cost":0.5},
						 "darkElfF":{"cost":0.5}}
			   }
	},
	"perkArtist":{
		"type":"item",
		"category":"perkArtist",
		"picture":{"file":"artist.atf"},
		"name":{"EN":"artist",
				"FR":"artiste",
				"DE":"künstler"},
		"description":{"EN":"This perk increases your skills affiliated with the work of stone.",
					   "FR":"Ce talent augmente vos compétences affiliés au travail de la pierre.",
					   "DE":"Diese Vergünstigung erhöht die Fähigkeiten, die mit der Arbeit von Stein verbunden sind."},
		"bonus":{"sculpting":{"address":0.5},
				 "stonecutting":{"strength":0.5}},
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":6}
	},
	"perkAssassin":{
		"type":"item",
		"category":"perkAssassin",
		"picture":{"file":"assassin.atf"},
		"name":{"EN":"assassin",
				"FR":"assassin",
				"DE":"mörder"},
		"description":{"EN":"This perk increases your light weapons and light armor skills.",
					   "FR":"Ce talent augmente vos compétences d'armes légères et d'armures légères.",
					   "DE":"Diese Vergünstigung erhöht Ihre Fähigkeiten Kleinwaffen und leichte Rüstung."},
		"bonus":{"lightWeapons":{"address":0.5},
				 "lightArmors":{"rapidity":0.5}},
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":20, "levelMin":30}
	},
	"perkAstrologer":{
		"type":"item",
		"category":"perkAstrologer",
		"picture":{"file":"astrologer.atf"},
		"name":{"EN":"astrologer",
				"FR":"astrologue",
				"DE":"astrologe"},
		"description":{"EN":"This perk increases your mana.",
					   "FR":"Ce talent augmente votre mana.",
					   "DE":"Diese Vergünstigung erhöht dein Mana."},
		"bonus":{"mana":20},
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":12, "levelMin":10}
	},
	"perkAthletic":{
		"type":"item",
		"category":"perkAthletic",
		"picture":{"file":"athletic.atf"},
		"name":{"EN":"athletic",
				"FR":"sportif",
				"DE":"sportlich"},
		"description":{"EN":"This perk increases your stamina.",
					   "FR":"Ce talent augmente votre énergie.",
					   "DE":"Diese Vergünstigung erhöht die Ausdauer."},
		"bonus":{"stamina":25},
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":11, "levelMin":10}
	},
	"perkBottomlessBag":{
		"type":"item",
		"category":"perkBottomlessBag",
		"picture":{"file":"bottomlessBag.atf"},
		"name":{"EN":"bottomless bag",
				"FR":"sac sans fond",
				"DE":"Bodenlose Tasche"},
		"description":{"EN":"This talent increases the amount of resources you can carry by 1000 units.",
					   "FR":"Ce talent augmente la quantité de ressoures que voux pouvez transporter de 1000 unités.",
					   "DE":"Dieses Talent erhöht die Menge an Ressourcen, die Sie mit 1000 Einheiten tragen können."},
		"resourcesMaxQuantity":1000,
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":100, "levelMin":100}
	},
	"perkCabinetmaker":{
		"type":"item",
		"category":"perkCabinetmaker",
		"picture":{"file":"cabinetmaker.atf"},
		"name":{"EN":"cabinetmaker",
				"FR":"ébéniste",
				"DE":"kunsttischler"},
		"description":{"EN":"This perk increases your sawing skill.",
					   "FR":"Ce talent augmente votre compétence de scierie.",
					   "DE":"Diese Vergünstigung erhöht ihre Sägefähigkeit."},
		"bonus":{"sawing":{"strength":0.5}},
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":5}
	},
	"perkCavalry":{
		"type":"item",
		"category":"perkCavalry",
		"picture":{"file":"cavalry.atf"},
		"name":{"EN":"cavalry",
				"FR":"cavalerie",
				"DE":"kavallerie"},
		"description":{"EN":"This perk increases your riding skill.",
					   "FR":"Ce talent augmente votre compétence d'équitation.",
					   "DE":"Diese Vergünstigung erhöht Ihre Reitfähigkeit."},
		"bonus":{"riding":{"charisma":0.5}},
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":20, "levelMin":40}
	},
	"perkChef":{
		"type":"item",
		"category":"perkChef",
		"picture":{"file":"chef.atf"},
		"name":{"EN":"chef",
				"FR":"chef cuisinier",
				"DE":"koch"},
		"description":{"EN":"This perk increases your cooking skills.",
					   "FR":"Ce talent augmente vos compétences de cuisine.",
					   "DE":"Diese Vergünstigung erhöht Ihre Kochkünste."},
		"bonus":{"bakery":{"rapidity":1},
				 "butchery":{"endurance":0.5}},
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":9, "levelMin":10,
				"races":{"felineM":{"cost":0.5, "levelMin":0.1},
						 "felineF":{"cost":0.5, "levelMin":0.1}}
				}
	},
	"perkChildOfTheSun":{
		"type":"item",
		"category":"perkChildOfTheSun",
		"picture":{"file":"childOfTheSun.atf"},
		"name":{"EN":"child of the sun",
				"FR":"enfant du soleil",
				"DE":"Kind der Sonne"},
		"description":{"EN":"This perk increases your mastery of the light magic.",
					   "FR":"Ce talent augmente votre maîtrise de la magie de lumière.",
					   "DE":"Diese Vergünstigung erhöht die Beherrschung der leichten magie."},
		"bonus":{"repressiveMagic":{"intelligence":0.5},
				 "redemptiveMagic":{"willpower":0.5}},
		"resistance":{"light":-0.1},
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":22, "levelMin":30,
				"races":{"darkElfM":{"cost":2, "levelMin":2},
						 "darkElfF":{"cost":2, "levelMin":2}}
				}
	},
	"perkClever":{
		"type":"item",
		"category":"perkClever",
		"picture":{"file":"clever.atf"},
		"name":{"EN":"clever",
				"FR":"intelligent",
				"DE":"klug"},
		"description":{"EN":"This perk increases your intelligence.",
					   "FR":"Ce talent augmente votre intelligence.",
					   "DE":"Diese Vergünstigung erhöht Ihre Intelligenz."},
		"bonus":{"intelligence":20},
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":10, "levelMin":20,
				"races":{"elfeM":{"cost":0.5, "levelMin":0.5},
						 "elfeF":{"cost":0.5, "levelMin":0.5},
						 "halfElfM":{"cost":0.75},
						 "halfElfF":{"cost":0.75},
						 "colossusM":{"cost":2, "levelMin":2},
						 "colossusF":{"cost":2, "levelMin":2}}
			   }
	},
	"perkFarmer":{
		"type":"item",
		"category":"perkFarmer",
		"picture":{"file":"farmer.atf"},
		"name":{"EN":"farmer",
				"FR":"fermier",
				"DE":"Bauer"},
		"description":{"EN":"This perk increases your skills affiliated with the work of the field.",
					   "FR":"Ce talent augmente vos compétences affiliés au travail de la terre.",
					   "DE":"Diese Vergünstigung erhöht Ihre Fähigkeiten mit der Arbeit des Feldes angeschlossen."},
		"bonus":{"farming":{"willpower":0.5},
				 "harvesting":{"rapidity":0.5}},
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":6}
	},
	"perkFirstAid":{
		"type":"item",
		"category":"edible",
		"picture":{"file":"firstAid.atf"},
		"name":{"EN":"first aid",
				"FR":"premiers soins",
				"DE":"Erste Hilfe"},
		"description":{"EN":"This perk allows you to heal yourself every 5 minutes.",
					   "FR":"Ce talent vous permet de vous guérir toutes les 5 minutes.",
					   "DE":"Diese Vergünstigung erlaubt Ihnen, sich selbst zu heilen alle 5 Minuten."},
		"use":{
			"cooldown":{"id":"firstAid",
						"time":300,
						"off":{"EN":{"D":["I can't use first aid for now."]},
							   "FR":{"D":["Je ne peux pas encore réutiliser les premiers soins."]},
							   "DE":{"D":["Ich kann jetzt keine Erste Hilfe benutzen."]}}},
			"gainPrimaryCharacteristic":{"health":{"address":0.5}},
			"xpSecondaryCharacteristic":{"address":50}
		},
		"secret":true,
		"indestructible":true,
		"perk":{"cost":15, "levelMin":10}
	},
	"perkGolemsSecret":{
		"type":"item",
		"category":"perkGolemsSecret",
		"picture":{"file":"golemsSecret.atf"},
		"name":{"EN":"golems secret",
				"FR":"secret des golems",
				"DE":"Golems Geheimnis"},
		"description":{"EN":"This perk increases your golemology skill.",
					   "FR":"Ce talent augmente votre compétence de golemologie.",
					   "DE":"Diese Vergünstigung erhöht Ihre Golemologie-Fertigkeit."},
		"bonus":{"golemology":{"intelligence":1}},
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":14, "levelMin":40,
				"races":{"astalanM":{"cost":0.25, "levelMin":0.25},
						 "astalanF":{"cost":0.25, "levelMin":0.25}}
			   }
	},
	"perkGreed":{
		"type":"item",
		"category":"perkGreed",
		"picture":{"file":"greed.atf"},
		"name":{"EN":"greed",
				"FR":"avidité",
				"DE":"gier"},
		"description":{"EN":"This perk increases your precious mineral skills.",
					   "FR":"Ce talent augmente vos compétences en minéraux précieux.",
					   "DE":"Diese Vergünstigung erhöht Ihre kostbaren Mineralien."},
		"bonus":{"gemmology":{"intelligence":1}},
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":12, "levelMin":20,
				"races":{"dwarfM":{"cost":0.5, "levelMin":0.5},
						 "dwarfF":{"cost":0.5, "levelMin":0.5}}
			   }
	},
	"perkGuard":{
		"type":"item",
		"category":"perkGuard",
		"picture":{"file":"guard.atf"},
		"name":{"EN":"guard",
				"FR":"garde",
				"DE":"bewachen"},
		"description":{"EN":"This perk increases your polearm and medium armor skills.",
					   "FR":"Ce talent augmente vos compétences d'armes d'hast et d'armures moyennes.",
					   "DE":"Diese Vergünstigung erhöht die Polearm- und Mittelpanzerfertigkeiten."},
		"bonus":{"polearms":{"strength":0.5},
				 "mediumArmors":{"endurance":0.5}},
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":20, "levelMin":30}
	},
	"perkGunNut":{
		"type":"item",
		"category":"perkGunNut",
		"picture":{"file":"gunNut.atf"},
		"name":{"EN":"gun nut",
				"FR":"fana des armes",
				"DE":"verrücktenWaffen"},
		"description":{"EN":"This perk increases your guns skills.",
					   "FR":"Ce talent augmente vos compétences d'armes à feu.",
					   "DE":"Diese Vergünstigung erhöht Ihre Waffen Fähigkeiten."},
		"bonus":{"firearms":{"address":0.5}},
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":20, "levelMin":40,
				"races":{"elfeM":{"cost":2, "levelMin":2},
						 "elfeF":{"cost":2, "levelMin":2},
						 "halfElfM":{"cost":1.5, "levelMin":1.5},
						 "halfElfF":{"cost":1.5, "levelMin":1.5}}
			   }
	},
	"perkHammerman":{
		"type":"item",
		"category":"perkHammerman",
		"picture":{"file":"hammerman.atf"},
		"name":{"EN":"hammerman",
				"FR":"marteleur",
				"DE":"hammerman"},
		"description":{"EN":"This perk increases your blunt weapons skill.",
					   "FR":"Ce talent augmente vos compétences d'armes contondantes.",
					   "DE":"Diese Vergünstigung erhöht die stumpfe Waffenfertigkeit."},
		"bonus":{"bluntWeapons":{"strength":0.5}},
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":14, "levelMin":30,
				"races":{"colossusM":{"cost":0.5},
						 "colossusF":{"cost":0.5}}
			   }
	},
	"perkHardInBusiness":{
		"type":"item",
		"category":"perkHardInBusiness",
		"picture":{"file":"hardInBusiness.atf"},
		"name":{"EN":"hard in business",
				"FR":"dur en affaires",
				"DE":"Hart im Geschäft"},
		"description":{"EN":"This perk increases your trading skill.",
					   "FR":"Ce talent augmente votre compétence de marchandage.",
					   "DE":"Diese Vergünstigung erhöht Ihre Handelsfähigkeit."},
		"bonus":{"trading":{"charisma":0.5}},
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":5,
				"races":{"dwarfM":{"cost":0.5, "levelMin":0.5},
						 "dwarfF":{"cost":0.5, "levelMin":0.5}}
			   }
	},
	"perkHealingOrb":{
		"type":"item",
		"category":"edible",
		"picture":{"file":"healingOrb.atf"},
		"name":{"EN":"healing orb",
				"FR":"orbe curative",
				"DE":"Heilende Kugel"},
		"description":{"EN":"This orb generates medicinal herbs continuously.",
					   "FR":"Cette orbe génère des herbes médicinales en continue.",
					   "DE":"Diese Kugel produziert Heilkräuter kontinuierlich."},
		"autoUse":{
			"time":20,
			"gainRessource":{"medicinalHerbs":1}
		},
		"secret":true,
		"indestructible":true,
		"perk":{"cost":40, "levelMin":50,
				"races":{"dwarfM":{"cost":2, "levelMin":2},
						 "dwarfF":{"cost":2, "levelMin":2}}
				}
	},
	"perkHornOfPlenty":{
		"type":"item",
		"category":"edible",
		"picture":{"file":"hornOfPlenty.atf"},
		"name":{"EN":"horn of plenty",
				"FR":"corne d'abondance",
				"DE":"Füllhorn"},
		"description":{"EN":"This horn generates fruit continuously.",
					   "FR":"Cette corne génère des fruits en continue.",
					   "DE":"Dieses Horn produziert kontinuierlich Früchte."},
		"autoUse":{
			"time":20,
			"gainRessource":{"fruits":1}
		},
		"secret":true,
		"indestructible":true,
		"perk":{"cost":40, "levelMin":50}
	},
	"perkIncreasedEncumberance":{
		"type":"item",
		"category":"perkIncreasedEncumberance",
		"picture":{"file":"increasedEncumberance.atf"},
		"name":{"EN":"increased encumberance",
				"FR":"encombrement amélioré",
				"DE":"Erhöhung der Belastung"},
		"description":{"EN":"This talent increases the amount of resources you can carry by 100 units.",
					   "FR":"Ce talent augmente la quantité de ressoures que voux pouvez transporter de 100 unités.",
					   "DE":"Dieses Talent erhöht die Menge an Ressourcen, die Sie mit 100 Einheiten tragen können."},
		"resourcesMaxQuantity":100,
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":30, "levelMin":40,
				"races":{"dwarfM":{"cost":0.5, "levelMin":0.5},
						 "dwarfF":{"cost":0.5, "levelMin":0.5}}
			   }
	},
	"perkInnkeeper":{
		"type":"item",
		"category":"perkInnkeeper",
		"picture":{"file":"innkeeper.atf"},
		"name":{"EN":"innkeeper",
				"FR":"tavernier",
				"DE":"gastwirt"},
		"description":{"EN":"This perk increases your alcohols skill.",
					   "FR":"Ce talent augmente votre compétence d'alcools.",
					   "DE":"Diese Vergünstigung erhöht den Alkoholgeist."},
		"bonus":{"alcohols":{"address":0.5}},
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":4,
				"races":{"dwarfM":{"cost":0.5, "levelMin":0.5},
						 "dwarfF":{"cost":0.5, "levelMin":0.5}}
			   }
	},
	"perkIronOrb":{
		"type":"item",
		"category":"edible",
		"picture":{"file":"ironOrb.atf"},
		"name":{"EN":"iron orb",
				"FR":"orbe ferrique",
				"DE":"Heilende Kugel"},
		"description":{"EN":"This orb generates iron continuously.",
					   "FR":"Cette orbe génère du fer en continue.",
					   "DE":"Diese Kugel erzeugt Eisen kontinuierlich."},
		"autoUse":{
			"time":20,
			"gainRessource":{"iron":1}
		},
		"secret":true,
		"indestructible":true,
		"perk":{"cost":80, "levelMin":50,
				"races":{"dwarfM":{"cost":0.5, "levelMin":0.8},
						 "dwarfF":{"cost":0.5, "levelMin":0.8}}
				}
	},
	"perkKeenSense":{
		"type":"item",
		"category":"perkKeenSense",
		"picture":{"file":"keenSense.atf"},
		"name":{"EN":"keen sense",
				"FR":"sens aiguisés",
				"DE":"scharfes gefühl"},
		"description":{"EN":"This perk increases your rapidity.",
					   "FR":"Ce talent augmente votre rapidité.",
					   "DE":"Dieser Vergünstigung erhöht Ihre Schnelligkeit."},
		"bonus":{"rapidity":25},
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":5,
				"restricted":["felineM", "felineF"]
			   }
	},
	"perkLearning":{
		"type":"item",
		"category":"perkLearning",
		"picture":{"file":"learning.atf"},
		"name":{"EN":"learning",
				"FR":"apprentissage",
				"DE":"Lernen"},
		"description":{"EN":"This perk increases your experience points gain by 10%.",
					   "FR":"Ce talent augmente votre gain de points d'expérience de 10%.",
					   "DE":"Dieser Vergünstigung erhöht Ihre Erfahrungspunkte um 10%."},
		"bonusXP":0.1,
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":20,
				"races":{"humanM":{"cost":0.75},
						 "humanF":{"cost":0.75},
						 "colossusM":{"cost":1.25},
						 "colossusF":{"cost":1.25}}
				}
	},
	"perkLevitation":{
		"type":"item",
		"category":"perkLevitation",
		"picture":{"file":"levitation.atf"},
		"name":{"EN":"levitation",
				"FR":"lévitation",
				"DE":"levitation"},
		"description":{"EN":"This perk allows you to fly and avoid obstacles.",
					   "FR":"Ce talent vous permet de voler et d'éviter les obstacles.",
					   "DE":"Diese Vergünstigung ermöglicht es Ihnen, zu fliegen und Hindernisse zu vermeiden"},
		"bonus":{"speed":0.5},
		"flying":true,
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":100, "levelMin":100}
	},
	"perkMagicResistance":{
		"type":"item",
		"category":"perkMagicResistance",
		"picture":{"file":"magicResistance.atf"},
		"name":{"EN":"magic resistance",
				"FR":"résistance magique",
				"DE":"magieresistenz"},
		"description":{"EN":"This perk increases your resistance to all magic.",
					   "FR":"Ce talent augmente votre résistance à toutes les magies.",
					   "DE":"Diese Vergünstigung erhöht deinen Widerstand gegen alle Magie."},
		"resistance":{"magic":-0.1},
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":15, "levelMin":20}
	},
	"perkMarksmanship":{
		"type":"item",
		"category":"perkMarksmanship",
		"picture":{"file":"marksmanship.atf"},
		"name":{"EN":"marksmanship",
				"FR":"adresse au tir",
				"DE":"Schießkunst"},
		"description":{"EN":"This perk increases your range skills.",
					   "FR":"Ce talent augmente vos compétences de tir.",
					   "DE":"Diese Vergünstigung erhöht Ihre Reichweite Fähigkeiten."},
		"bonus":{"throwingWeapons":{"address":0.5},
				 "bows":{"address":0.5},
				 "shootingWeapons":{"address":0.5}},
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":20, "levelMin":30,
				"races":{"elfeM":{"cost":0.5, "levelMin":0.5},
						 "elfeF":{"cost":0.5, "levelMin":0.5},
						 "halfElfM":{"cost":0.75},
						 "halfElfF":{"cost":0.75}}
			   }
	},
	"perkMasterBuilder":{
		"type":"item",
		"category":"perkMasterBuilder",
		"picture":{"file":"masterBuilder.atf"},
		"name":{"EN":"master-builder",
				"FR":"maître-batisseur",
				"DE":"Baumeister"},
		"description":{"EN":"This perk increases your building skill.",
					   "FR":"Ce talent augmente votre compétence de construction.",
					   "DE":"Diese Vergünstigung erhöht Ihr Gebäude Geschick."},
		"bonus":{"building":{"strength":0.5},
				 "repairing":{"endurance":0.5},
				 "fortification":{"strength":0.5}},
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":8}
	},
	"perkMasterOfStorms":{
		"type":"item",
		"category":"perkMasterOfStorms",
		"picture":{"file":"masterOfStorms.atf"},
		"name":{"EN":"master of storms",
				"FR":"maître des tempêtes",
				"DE":"Meister der Stürme"},
		"description":{"EN":"This perk increases your mastery of the magic of lightning and ice.",
					   "FR":"Ce talent augmente votre maîtrise de la magie de foudre et de glace.",
					   "DE":"Diese Vergünstigung erhöht die Meisterschaft der Magie Blitz und Eis."},
		"bonus":{"shamanicMagic":{"intelligence":0.5},
				 "druidicMagic":{"willpower":0.5}},
		"resistance":{"ice":-0.1,
					  "electricity":-0.1},
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":28, "levelMin":30}
	},
	"perkMeditation":{
		"type":"item",
		"category":"edible",
		"picture":{"file":"meditation.atf"},
		"name":{"EN":"meditation",
				"FR":"méditation",
				"DE":"meditation"},
		"description":{"EN":"This perk allows you to recover mana every 5 minutes.",
					   "FR":"Ce talent vous permet de récupérer du mana toutes les 5 minutes.",
					   "DE":"Diese Vergünstigung erlaubt Ihnen, Mana zu erholen alle 5 Minuten."},
		"use":{
			"cooldown":{"id":"meditation",
						"time":300,
						"off":{"EN":{"D":["I can't use meditation for now."]},
							   "FR":{"D":["Je ne peux pas encore réutiliser la méditation."]},
							   "DE":{"D":["Ich kann jetzt keine Meditation benutzen."]}}},
			"gainPrimaryCharacteristic":{"mana":{"willpower":0.5}},
			"xpSecondaryCharacteristic":{"willpower":50}
		},
		"secret":true,
		"indestructible":true,
		"perk":{"cost":17, "levelMin":10}
	},
	"perkMidasTouch":{
		"type":"item",
		"category":"edible",
		"picture":{"file":"MidasTouch.atf"},
		"name":{"EN":"Midas Touch",
				"FR":"touché de Midas",
				"DE":"Midas Berührenb"},
		"description":{"EN":"This perk generates gold continuously.",
					   "FR":"Ce talent génère de l'or en continue.",
					   "DE":"Diese Vergünstigung erzeugt Gold kontinuierlich."},
		"autoUse":{
			"time":20,
			"gainRessource":{"gold":1}
		},
		"secret":true,
		"indestructible":true,
		"perk":{"cost":100, "levelMin":100,
				"races":{"dwarfM":{"cost":0.5, "levelMin":0.5},
						 "dwarfF":{"cost":0.5, "levelMin":0.5}}
				}
	},
	"perkMilitaryDecoration":{
		"type":"item",
		"category":"perkMilitaryDecoration",
		"picture":{"file":"militaryDecoration.atf"},
		"name":{"EN":"military decoration",
				"FR":"décoration militaire",
				"DE":"Militär-Dekoration"},
		"description":{"EN":"This perk increases your recruitment skill.",
					   "FR":"Ce talent augmente votre compétences de recrutement.",
					   "DE":"Diese Vergünstigung erhöht Ihre Rekrutierungsfähigkeit."},
		"bonus":{"conscription":{"charisma":1}},
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":10, "levelMin":40,
				"races":{"humanM":{"cost":0.5, "levelMin":0.5},
						 "humanF":{"cost":0.5, "levelMin":0.5}}
			   }
	},
	"perkNaturalRegeneration":{
		"type":"item",
		"category":"perkNaturalRegeneration",
		"picture":{"file":"naturalRegeneration.atf"},
		"name":{"EN":"natural regeneration",
				"FR":"régénération naturelle",
				"DE":"natürliche Regeneration"},
		"description":{"EN":"This perk increases your health regeneration.",
					   "FR":"Ce talent augmente votre régénération de santé.",
					   "DE":"Diese Vergünstigung erhöht die Gesundheitsregeneration."},
		"bonusRegeneration":{"health":2},
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":10, "levelMin":20}
	},
	"perkOrbOfTheHarvests":{
		"type":"item",
		"category":"edible",
		"picture":{"file":"orbOfTheHarvests.atf"},
		"name":{"EN":"orb of the harvests",
				"FR":"orbe des moissons",
				"DE":"orb Ernte"},
		"description":{"EN":"This orb generates grain continuously.",
					   "FR":"Cette orbe génère des céréales en continue.",
					   "DE":"Diese Kugel erzeugt kontinuierlich Getreide."},
		"autoUse":{
			"time":20,
			"gainRessource":{"grain":1}
		},
		"secret":true,
		"indestructible":true,
		"perk":{"cost":40, "levelMin":50}
	},
	"perkPoacher":{
		"type":"item",
		"category":"perkPoacher",
		"picture":{"file":"poacher.atf"},
		"name":{"EN":"poacher",
				"FR":"braconnier",
				"DE":"wilderer"},
		"description":{"EN":"This perk increases your hunting skill.",
					   "FR":"Ce talent augmente votre compétence de chasse.",
					   "DE":"Diese Vergünstigung erhöht die Jagdfertigkeit."},
		"bonus":{"zoology":{"willpower":0.25},
				 "hunting":{"address":0.5},
				 "tanning":{"address":0.25}},
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":7}
	},
	"perkRobustness":{
		"type":"item",
		"category":"perkRobustness",
		"picture":{"file":"robustness.atf"},
		"name":{"EN":"robustness",
				"FR":"robustesse",
				"DE":"stärke"},
		"description":{"EN":"This perk increases your health.",
					   "FR":"Ce talent augmente votre santé.",
					   "DE":"Diese Vergünstigung erhöht die Gesundheit."},
		"bonus":{"health":20},
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":10, "levelMin":10}
	},
	"perkSecondWind":{
		"type":"item",
		"category":"edible",
		"picture":{"file":"secondWind.atf"},
		"name":{"EN":"second wind",
				"FR":"second souffle",
				"DE":"Zweiter Wind"},
		"description":{"EN":"This perk allows you to gain stamina every 5 minutes.",
					   "FR":"Ce talent vous permet de regagner de l'énergie toutes les 5 minutes.",
					   "DE":"Diese Vergünstigung erlaubt Ihnen, alle 5 Minuten Ausdauer zu bekommen."},
		"use":{
			"cooldown":{"id":"secondWind",
						"time":300,
						"off":{"EN":{"D":["I can't use second wind for now."]},
							   "FR":{"D":["Je ne peux pas encore réutiliser le second souffle."]},
							   "DE":{"D":["Ich kann jetzt keine Zweiter Wind benutzen."]}}},
			"gainPrimaryCharacteristic":{"stamina":{"endurance":0.5}},
			"xpSecondaryCharacteristic":{"endurance":50}
		},
		"secret":true,
		"indestructible":true,
		"perk":{"cost":16, "levelMin":10}
	},
	"perkServantOfDarkness":{
		"type":"item",
		"category":"perkServantOfDarkness",
		"picture":{"file":"servantOfDarkness.atf"},
		"name":{"EN":"servant of darkness",
				"FR":"serviteur des ténèbres",
				"DE":"Diener der Dunkelheit"},
		"description":{"EN":"This perk increases your mastery of black magic.",
					   "FR":"Ce talent augmente votre maîtrise de la magie noire.",
					   "DE":"Diese Vergünstigung erhöht deine Meisterschaft der schwarzen Magie."},
		"bonus":{"chaoticMagic":{"intelligence":0.5},
				 "necromanticMagic":{"willpower":0.5}},
		"resistance":{"death":-0.1},
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":30, "levelMin":30,
				"races":{"darkElfM":{"cost":0.5, "levelMin":0.5},
						 "darkElfF":{"cost":0.5, "levelMin":0.5}}
			   }
	},
	"perkSpecialistInMinerals":{
		"type":"item",
		"category":"perkSpecialistInMinerals",
		"picture":{"file":"specialistInMinerals.atf"},
		"name":{"EN":"specialist in minerals",
				"FR":"spécialiste en minéraux",
				"DE":"Spezialist für Mineralien"},
		"description":{"EN":"This perk increases your research and mineral extraction skills.",
					   "FR":"Ce talent augmente vos compétences de recherche et d'extraction des minéraux.",
					   "DE":"Diese Vergünstigung erhöht Ihre Forschung und Mineral-Extraktion Fähigkeiten."},
		"bonus":{"lithology":{"intelligence":0.75},
				 "prospecting":{"willpower":0.75},
				 "mining":{"endurance":0.75}},
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":22, "levelMin":20,
				"races":{"dwarfM":{"cost":0.5, "levelMin":0.5},
						 "dwarfF":{"cost":0.5, "levelMin":0.5},
						 "astalanM":{"cost":0.5, "levelMin":0.5},
						 "astalanF":{"cost":0.5, "levelMin":0.5}}
			   }
	},
	"perkStoneOrb":{
		"type":"item",
		"category":"edible",
		"picture":{"file":"stoneOrb.atf"},
		"name":{"EN":"stone orb",
				"FR":"orbe de pierre",
				"DE":"Kugel Stein"},
		"description":{"EN":"This orb generates stone continuously.",
					   "FR":"Cette orbe génère de la pierre en continue.",
					   "DE":"Diese Kugel erzeugt Stein kontinuierlich"},
		"autoUse":{
			"time":20,
			"gainRessource":{"stone":1}
		},
		"secret":true,
		"indestructible":true,
		"perk":{"cost":50, "levelMin":50}
	},
	"perkSwordman":{
		"type":"item",
		"category":"perkSwordman",
		"picture":{"file":"swordman.atf"},
		"name":{"EN":"swordman",
				"FR":"épéiste",
				"DE":"schwertkämpfer"},
		"description":{"EN":"This perk increases your edged weapons skill.",
					   "FR":"Ce talent augmente votre compétence d'armes tranchantes.",
					   "DE":"Diese Vergünstigung erhöht die Kantenwaffen."},
		"bonus":{"edgedWeapons":{"strength":0.5}},
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":15, "levelMin":30}
	},
	"perkSylvanOrb":{
		"type":"item",
		"category":"edible",
		"picture":{"file":"sylvanOrb.atf"},
		"name":{"EN":"sylvan orb",
				"FR":"orbe sylvestre",
				"DE":"orb Schotten"},
		"description":{"EN":"This orb generates wood continuously.",
					   "FR":"Cette orbe génère du bois en continue.",
					   "DE":"Diese Kugel erzeugt Holz weiter."},
		"autoUse":{
			"time":20,
			"gainRessource":{"wood":1}
		},
		"secret":true,
		"indestructible":true,
		"perk":{"cost":40, "levelMin":50,
				"races":{"elfeM":{"cost":0.5, "levelMin":0.5},
						 "elfeF":{"cost":0.5, "levelMin":0.5},
						 "halfElfM":{"cost":0.75, "levelMin":0.8},
						 "halfElfF":{"cost":0.75, "levelMin":0.8},
						 "dwarfM":{"cost":2, "levelMin":2},
						 "dwarfF":{"cost":2, "levelMin":2}}
				}
	},
	"perkTank":{
		"type":"item",
		"category":"perkTank",
		"picture":{"file":"tank.atf"},
		"name":{"EN":"tank",
				"FR":"tank",
				"DE":"tank"},
		"description":{"EN":"This perk increases your heavy armor and shield skills.",
					   "FR":"Ce talent augmente vos compétences d'amures lourdes et de bouclier.",
					   "DE":"Diese Vergünstigung erhöht Ihre schwere Rüstung und Schild Fähigkeiten."},
		"bonus":{"shields":{"endurance":0.5},
				 "heavyArmors":{"endurance":0.5}},
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":24, "levelMin":30,
				"races":{"elfeM":{"cost":2},
						 "elfeF":{"cost":2},
						 "halfElfM":{"cost":1.5},
						 "halfElfF":{"cost":1.5},
						 "felineM":{"cost":1.5},
						 "felineF":{"cost":1.5},
						 "dwarfM":{"cost":0.75},
						 "dwarfF":{"cost":0.75},
						 "colossusM":{"cost":0.5},
						 "colossusF":{"cost":0.5}}
			   }
	},
	"perkTheology":{
		"type":"item",
		"category":"perkTheology",
		"picture":{"file":"theology.atf"},
		"name":{"EN":"theology",
				"FR":"théologie",
				"DE":"theologie"},
		"description":{"EN":"This perk increases your willpower.",
					   "FR":"Ce talent augmente votre volonté.",
					   "DE":"Diese Vergünstigung erhöht Ihre Willenskraft."},
		"bonus":{"willpower":20},
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":10, "levelMin":20}
	},
	"perkTitleOfNobility":{
		"type":"item",
		"category":"edible",
		"picture":{"file":"titleOfNobility.atf"},
		"name":{"EN":"title of nobility",
				"FR":"titre de noblesse",
				"DE":"adelstitel"},
		"description":{"EN":"This perk generates silver coins continuously.",
					   "FR":"Cette orbe génère des pîèces d'argent en continue.",
					   "DE":"Diese Kugel erzeugt Holz weiter."},
		"autoUse":{
			"time":20,
			"gainRessource":{"silverCoin":1}
		},
		"secret":true,
		"indestructible":true,
		"perk":{"cost":50, "levelMin":50,
				"restricted":["humanM", "humanF"]
				}
	},
	"perkTraveler":{
		"type":"item",
		"category":"perkTraveler",
		"picture":{"file":"traveler.atf"},
		"name":{"EN":"traveler",
				"FR":"voyageur",
				"DE":"reisende"},
		"description":{"EN":"This perk increases your starting speed.",
					   "FR":"Ce talent augmente votre vitesse de déplacement de départ.",
					   "DE":"Dieses Vergünstigung erhöht die Startgeschwindigkeit."},
		"bonusSpeed":0.5,
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":40, "levelMin":40}
	},
	"perkViking":{
		"type":"item",
		"category":"perkViking",
		"picture":{"file":"viking.atf"},
		"name":{"EN":"viking",
				"FR":"viking",
				"DE":"Wikinger"},
		"description":{"EN":"This perk increases your axes skill.",
					   "FR":"Ce talent augmente votre compétence de haches.",
					   "DE":"Diese Vergünstigung erhöht Ihre Axtfertigkeit."},
		"bonus":{"axes":{"strength":0.5}},
		"resistance":{"ice":-0.1},
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":18, "levelMin":30,
				"races":{"dwarfM":{"cost":0.5},
						 "dwarfF":{"cost":0.5}}
				}
	},
	"perkVisualAcuity":{
		"type":"item",
		"category":"perkVisualAcuity",
		"picture":{"file":"visualAcuity.atf"},
		"name":{"EN":"visual acuity",
				"FR":"acuité visuelle",
				"DE":"sehschärfe"},
		"description":{"EN":"This perk increases your address.",
					   "FR":"Ce talent augmente votre adresse.",
					   "DE":"Dieser Vergünstigung erhöht Ihre Adressiert."},
		"bonus":{"address":25},
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":10, "levelMin":20,
				"races":{"elfeM":{"cost":0.5, "levelMin":0.5},
						 "elfeF":{"cost":0.5, "levelMin":0.5},
						 "halfElfM":{"cost":0.75},
						 "halfElfF":{"cost":0.75},
						 "felineM":{"cost":0.5, "levelMin":0.05},
						 "felineF":{"cost":0.5, "levelMin":0.05},
						 "dwarfM":{"cost":2},
						 "dwarfF":{"cost":2}}
			   }
	},
	"perkWarriorBorn":{
		"type":"item",
		"category":"perkWarriorBorn",
		"picture":{"file":"warriorBorn.atf"},
		"name":{"EN":"warrior born",
				"FR":"guerrier né",
				"DE":"krieger geboren"},
		"description":{"EN":"This perk increases your attack and your defense.",
					   "FR":"Ce talent augmente votre attaque et votre défense.",
					   "DE":"Diese Vergünstigung erhöht deinen Angriff und deine Verteidigung."},
		"bonus":{"attack":{"strength":0.1},
				 "defense":{"endurance":0.05}},
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":30, "levelMin":20}
	},
	"perkWaterDivinerWand":{
		"type":"item",
		"category":"edible",
		"picture":{"file":"waterDivinerWand.atf"},
		"name":{"EN":"water diviner wand",
				"FR":"baguette de sourcier",
				"DE":"Wasserspender Zauberstab"},
		"description":{"EN":"This wand generates water continuously.",
					   "FR":"Cette baguette génère de l'eau en continue.",
					   "DE":"Dieser Stab erzeugt kontinuierlich Wasser."},
		"autoUse":{
			"time":20,
			"gainRessource":{"water":1}
		},
		"secret":true,
		"indestructible":true,
		"perk":{"cost":35, "levelMin":50,
				"races":{"elfeM":{"cost":0.8, "levelMin":0.8},
						 "elfeF":{"cost":0.8, "levelMin":0.8}}
				}
	},
	"perkWeightLauncher":{
		"type":"item",
		"category":"perkWeightLauncher",
		"picture":{"file":"weightLauncher.atf"},
		"name":{"EN":"weight launcher",
				"FR":"lanceur de poids",
				"DE":"gewicht Launcher"},
		"description":{"EN":"This perk increases your throwing weapons skill.",
					   "FR":"Ce talent augmente vos compétences d'armes de lancé.",
					   "DE":"Diese Vergünstigung erhöht die Waffe."},
		"bonus":{"throwingWeapons":{"address":0.5}},
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":13, "levelMin":30}
	},
	"perkWeightlifting":{
		"type":"item",
		"category":"perkWeightlifting",
		"picture":{"file":"weightlifting.atf"},
		"name":{"EN":"weightlifting",
				"FR":"musculation",
				"DE":"gewichtheben"},
		"description":{"EN":"This perk increases your strength and your endurance.",
					   "FR":"Ce talent augmente votre force et votre endurance.",
					   "DE":"Dieser Vergünstigung erhöht Ihre Kraft und Ihre Ausdauer."},
		"bonus":{"strength":25,
				 "endurance":10},
		"equip":true,
		"secret":true,
		"indestructible":true,
		"perk":{"cost":18, "levelMin":20,
				"races":{"colossusM":{"cost":0.5, "levelMin":0.5},
						 "colossusF":{"cost":0.5, "levelMin":0.5}}
			   }
	}
}